!Object constantsFor: 'Geos Libraries'!

geosLIB25 'SYSTEM\foamdb'! !

!Object constantsFor: 'Geos vardata'!

!

!Object constantsFor: 'Geos messages'!

!

!Geos class methodsFor: 'library calls'!

FoamDBOpen: filename with: mapBlockSize with: majorProtocol with: minorProtocol
	"VMFileHandle pascal FoamDBOpen(char *filename, word mapBlockSize, word majorProtocol, word minorProtocol) in foamdb.h"
	^GEOS call: filename with: mapBlockSize with: majorProtocol with: minorProtocol with: #[25 0 18 3 1 1 1 1]!

FoamDBClose: file
	"word pascal FoamDBClose(VMFileHandle file) in foamdb.h"
	^GEOS call: file with: #[25 0 19 1 1]!

FoamDBCreateEmptyRecord: file
	"MemHandle pascal FoamDBCreateEmptyRecord(VMFileHandle file) in foamdb.h"
	^GEOS call: file with: #[25 0 20 1 1]!

FoamDBDuplicateRecord: file with: record
	"MemHandle pascal FoamDBDuplicateRecord(VMFileHandle file, MemHandle record) in foamdb.h"
	^GEOS call: file with: record with: #[25 0 34 1 1 1]!

FoamDBGetRecordID: record
	"RecordID pascal FoamDBGetRecordID(MemHandle record) in foamdb.h"
	^GEOS call: record with: #[25 0 46 1 2]!

FoamDBAddFieldToRecord: file with: record with: fieldName with: fieldType
	"FieldID pascal FoamDBAddFieldToRecord(VMFileHandle file, MemHandle record, char *fieldName, word fieldType) in foamdb.h"
	^GEOS call: file with: record with: fieldName with: fieldType with: #[25 0 21 1 1 3 1 1]!

FoamDBDeleteFieldFromRecord: file with: record with: id
	"void pascal FoamDBDeleteFieldFromRecord(VMFileHandle file, MemHandle record, FieldID id) in foamdb.h"
	^GEOS call: file with: record with: id with: #[25 0 22 1 1 1 0]!

FoamDBSetFieldName: file with: record with: id with: name
	"void pascal FoamDBSetFieldName(VMFileHandle file, MemHandle record, FieldID id, char *name) in foamdb.h"
	^GEOS call: file with: record with: id with: name with: #[25 0 23 1 1 1 3 0]!

FoamDBSetFieldData: file with: record with: id with: data with: dataSize
	"void pascal FoamDBSetFieldData(VMFileHandle file, MemHandle record, FieldID id, char *data, word dataSize) in foamdb.h"
	^GEOS call: file with: record with: id with: data with: dataSize with: #[25 0 24 1 1 1 3 1 0]!

FoamDBGetFieldName: file with: record with: id with: dest with: maxBytesToGet
	"Boolean pascal FoamDBGetFieldName(VMFileHandle file, MemHandle record, FieldID id, TCHAR *dest, word maxBytesToGet) in foamdb.h"
	^GEOS call: file with: record with: id with: dest with: maxBytesToGet with: #[25 0 25 1 1 1 3 1 4]!

FoamDBGetFieldType: file with: record with: id with: type
	"Boolean pascal FoamDBGetFieldType(VMFileHandle file, MemHandle record, FieldID id, byte *type) in foamdb.h"
	^GEOS call: file with: record with: id with: type with: #[25 0 37 1 1 1 3 4]!

FoamDBGetFieldData: file with: record with: id with: dest with: maxBytesToGet
	"word pascal FoamDBGetFieldData(VMFileHandle file, MemHandle record, FieldID id, char *dest, word maxBytesToGet) in foamdb.h"
	^GEOS call: file with: record with: id with: dest with: maxBytesToGet with: #[25 0 26 1 1 1 3 1 1]!

FoamDBDiscardRecord: file with: record
	"void pascal FoamDBDiscardRecord(VMFileHandle file, MemHandle record) in foamdb.h"
	^GEOS call: file with: record with: #[25 0 29 1 1 0]!

FoamDBDeleteRecord: file with: record
	"Boolean pascal FoamDBDeleteRecord(VMFileHandle file, MemHandle record) in foamdb.h"
	^GEOS call: file with: record with: #[25 0 30 1 1 4]!

FoamDBGetRecordFromID: file with: id
	"MemHandle pascal FoamDBGetRecordFromID(VMFileHandle file, RecordID id) in foamdb.h"
	^GEOS call: file with: id with: #[25 0 31 1 2 1]!

FoamDBGetNumVisibleRecords: file
	"dword pascal FoamDBGetNumVisibleRecords(VMFileHandle file) in foamdb.h"
	^GEOS call: file with: #[25 0 32 1 2]!

FoamDBGetVisibleRecord: file with: index
	"MemHandle pascal FoamDBGetVisibleRecord(VMFileHandle file, dword index) in foamdb.h"
	^GEOS call: file with: index with: #[25 0 33 1 2 1]!

FoamDBMapTokenToName: file with: nameToken with: maxBytesToCopy with: dest
	"Boolean pascal FoamDBMapTokenToName(VMFileHandle file, word nameToken, word maxBytesToCopy, TCHAR *dest) in foamdb.h"
	^GEOS call: file with: nameToken with: maxBytesToCopy with: dest with: #[25 0 42 1 1 1 3 4]!

FoamDBSetNameForToken: file with: nameToken with: name
	"void pascal FoamDBSetNameForToken(VMFileHandle file, word nameToken, TCHAR *name) in foamdb.h"
	^GEOS call: file with: nameToken with: name with: #[25 0 64 1 1 3 0]!

FoamDBMapNameToToken: file with: nameToLookFor with: token
	"Boolean pascal FoamDBMapNameToToken(VMFileHandle file, TCHAR *nameToLookFor, word *token) in foamdb.h"
	^GEOS call: file with: nameToLookFor with: token with: #[25 0 40 1 3 3 4]!

FoamDBGetNextPrevRecord: file with: record with: count
	"dword pascal FoamDBGetNextPrevRecord(VMFileHandle file, RecordID record, word count) in foamdb.h"
	^GEOS call: file with: record with: count with: #[25 0 69 1 2 1 2]!

FoamDBSuspendNotifications: file
	"void pascal FoamDBSuspendNotifications(VMFileHandle file) in foamdb.h"
	^GEOS call: file with: #[25 0 50 1 0]!

FoamDBResumeNotifications: file
	"void pascal FoamDBResumeNotifications(VMFileHandle file) in foamdb.h"
	^GEOS call: file with: #[25 0 52 1 0]!

FoamDBGetCurrentRecordID: file
	"RecordID pascal FoamDBGetCurrentRecordID(VMFileHandle file) in foamdb.h"
	^GEOS call: file with: #[25 0 54 1 2]!

FoamDBSetCurrentRecordID: file with: id
	"void pascal FoamDBSetCurrentRecordID(VMFileHandle file, RecordID id) in foamdb.h"
	^GEOS call: file with: id with: #[25 0 56 1 2 0]!

FoamDBSuspendUpdates: file
	"void pascal FoamDBSuspendUpdates(VMFileHandle file) in foamdb.h"
	^GEOS call: file with: #[25 0 60 1 0]!

FoamDBResumeUpdates: file
	"void pascal FoamDBResumeUpdates(VMFileHandle file) in foamdb.h"
	^GEOS call: file with: #[25 0 62 1 0]!

FoamDBGetVisibleIndexFromID: file with: id
	"dword pascal FoamDBGetVisibleIndexFromID(VMFileHandle file, RecordID id) in foamdb.h"
	^GEOS call: file with: id with: #[25 0 72 1 2 2]!

!

